/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.edit;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.edit.EditBean;
import com.ibm.hwmca.fw.edit.EditProperties;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class EditTasklet
extends HwmcaPanelTasklet {
    private static final String TRACE_MASKT = "XEDTTSKT";
    private static final String TRACE_MASKF = "XEDTTSKF";
    private static final String TRACE_MASKD = "XEDTTSKD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.fw.edit.res.EditRes";
    private static final String PANEL_NAME = "EditPanel";
    private static final int PAGING_LENGTH = 0x200B20;
    private static final int LINES_PER_PAGE = 20;
    private static final String TEMP_DIRECTORY = "/tmp/hmc/edit/";
    private File file;
    private EditBean editBean;
    private boolean paging;
    private boolean readOnly;
    private int currentPage;
    private ArrayList pages;
    private String textEdit;
    private String textEditRestore;
    private BufferedReader reader;
    private BufferedWriter writer;
    private String subdirectory;

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        try {
            if (taskletRequest.isInitialRequest()) {
                String newTitle;
                Trace.trace(TRACE_MASKF, "Initial request ... ");
                EditProperties props = (EditProperties)this.presentationTaskParms.getData("props");
                this.file = new File(props.fileName);
                this.readOnly = props.readOnly;
                String panelTitle = props.title;
                if (panelTitle == null) {
                    int index = props.fileName.lastIndexOf(47);
                    String fileName = index != -1 ? props.fileName.substring(index + 1) : props.fileName;
                    newTitle = new String(fileName);
                } else {
                    newTitle = new String(panelTitle);
                }
                if (!this.file.exists() && props.createifnoexist) {
                    this.file.createNewFile();
                }
                if (this.file.exists()) {
                    this.editBean = new EditBean();
                    this.editBean.setBeanName("mybean");
                    long length = this.file.length();
                    if (length > 0L) {
                        if (length > 0x200B20L) {
                            this.subdirectory = UserContext.getCurrentUserContext().getUserid();
                            this.emptyDirectory().mkdirs();
                            this.currentPage = 0;
                            this.pages = new ArrayList();
                            this.paging = true;
                        } else {
                            this.paging = false;
                        }
                        this.textEdit = this.loadFile();
                    } else {
                        this.paging = false;
                        this.textEdit = new String("");
                    }
                    this.textEditRestore = new String(this.textEdit);
                    this.editBean.setPaging(this.paging);
                    this.editBean.setReadOnly(this.readOnly);
                    this.editBean.setTextEdit(this.textEdit);
                    this.editBean.setTitle(newTitle);
                    taskletResponse.replace(AUIML_FILE_NAME, PANEL_NAME, this.editBean);
                } else {
                    LocalizableText title = new LocalizableText(null, "EDIT");
                    BaseMessageText msgText = new BaseMessageText("EDIT1254");
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                    this.showMessageBox(true, title, msgText, MsgType.WARNING_MESSAGE, options);
                    taskletResponse.terminate();
                }
            } else if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                Trace.trace(TRACE_MASKF, "Disposing task ... ");
                taskletResponse.terminate();
            } else {
                String request = (String)taskletRequest.getData("request");
                Trace.trace(TRACE_MASKF, "Request = " + request);
                if (request.equals("save")) {
                    LocalizableText[] options;
                    BaseMessageText msgText;
                    LocalizableText title;
                    this.textEdit = (String)taskletRequest.getData("textedit");
                    if (this.isModified() && this.showMessageBox(true, title = new LocalizableText(null, "EDIT"), msgText = new BaseMessageText("EDIT1250"), MsgType.QUESTION_MESSAGE, options = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON}).equals(CommonMsgInterface.YES_BUTTON)) {
                        if (this.paging) {
                            if (!this.textEdit.equals(this.textEditRestore)) {
                                ((Page)this.pages.get(this.currentPage)).write(this.textEdit);
                            }
                            for (int i = 0; i < this.pages.size(); ++i) {
                                ((Page)this.pages.get(i)).setModified(false);
                            }
                        }
                        this.writeFile();
                        this.textEditRestore = new String(this.textEdit);
                    }
                    taskletResponse.noAction();
                } else if (request.equals("refresh")) {
                    this.textEdit = (String)taskletRequest.getData("textedit");
                    if (this.isModified()) {
                        LocalizableText title = new LocalizableText(null, "EDIT");
                        BaseMessageText msgText = new BaseMessageText("EDIT1251");
                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON};
                        if (this.showMessageBox(true, title, msgText, MsgType.QUESTION_MESSAGE, options).equals(CommonMsgInterface.YES_BUTTON)) {
                            if (this.paging) {
                                this.pages.clear();
                                this.emptyDirectory();
                                this.currentPage = 0;
                                this.textEdit = this.loadFile();
                                this.textEditRestore = new String(this.textEdit);
                            } else {
                                this.textEdit = this.textEditRestore;
                            }
                            taskletResponse.update("mybean", this.textEdit);
                        } else {
                            taskletResponse.noAction();
                        }
                    } else {
                        taskletResponse.noAction();
                    }
                } else if (request.equals("cancel")) {
                    if (!this.readOnly) {
                        this.textEdit = (String)taskletRequest.getData("textedit");
                        if (this.isModified()) {
                            LocalizableText title = new LocalizableText(null, "EDIT");
                            BaseMessageText msgText = new BaseMessageText("EDIT1252");
                            LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON};
                            if (this.showMessageBox(true, title, msgText, MsgType.QUESTION_MESSAGE, options).equals(CommonMsgInterface.YES_BUTTON)) {
                                taskletResponse.terminate();
                            } else {
                                taskletResponse.noAction();
                            }
                        } else {
                            taskletResponse.terminate();
                        }
                    } else {
                        taskletResponse.terminate();
                    }
                } else if (request.equals("pageup")) {
                    if (this.currentPage > 0) {
                        if (!this.readOnly) {
                            this.textEdit = (String)taskletRequest.getData("textedit");
                            Page current = (Page)this.pages.get(this.currentPage);
                            current.write(this.textEdit);
                            if (!this.textEdit.equals(this.textEditRestore)) {
                                current.setModified(true);
                            }
                        }
                        --this.currentPage;
                        this.textEdit = ((Page)this.pages.get(this.currentPage)).read();
                        this.textEditRestore = new String(this.textEdit);
                        taskletResponse.update("mybean", this.textEdit);
                    } else {
                        taskletResponse.noAction();
                    }
                } else if (request.equals("pagedown")) {
                    if (this.currentPage < this.pages.size() - 1) {
                        if (!this.readOnly) {
                            this.textEdit = (String)taskletRequest.getData("textedit");
                            Page current = (Page)this.pages.get(this.currentPage);
                            current.write(this.textEdit);
                            if (!this.textEdit.equals(this.textEditRestore)) {
                                current.setModified(true);
                            }
                        }
                        ++this.currentPage;
                        this.textEdit = ((Page)this.pages.get(this.currentPage)).read();
                        this.textEditRestore = new String(this.textEdit);
                        taskletResponse.update("mybean", this.textEdit);
                    } else {
                        taskletResponse.noAction();
                    }
                } else if (request.equals("findprev")) {
                    String key;
                    this.textEdit = (String)taskletRequest.getData("textedit");
                    Page current = (Page)this.pages.get(this.currentPage);
                    current.write(this.textEdit);
                    if (!this.textEdit.equals(this.textEditRestore)) {
                        current.setModified(true);
                    }
                    if (this.searchUp(key = (String)taskletRequest.getData("findedit"))) {
                        taskletResponse.update("mybean", this.textEdit);
                    } else {
                        LocalizableText title = new LocalizableText(null, "EDIT");
                        BaseMessageText msgText = new BaseMessageText("EDIT1253");
                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        this.showMessageBox(true, title, msgText, MsgType.INFORMATION_MESSAGE, options);
                        taskletResponse.noAction();
                    }
                } else if (request.equals("findnext")) {
                    String key;
                    this.textEdit = (String)taskletRequest.getData("textedit");
                    Page current = (Page)this.pages.get(this.currentPage);
                    current.write(this.textEdit);
                    if (!this.textEdit.equals(this.textEditRestore)) {
                        current.setModified(true);
                    }
                    if (this.searchDown(key = (String)taskletRequest.getData("findedit"))) {
                        taskletResponse.update("mybean", this.textEdit);
                    } else {
                        LocalizableText title = new LocalizableText(null, "EDIT");
                        BaseMessageText msgText = new BaseMessageText("EDIT1253");
                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        this.showMessageBox(true, title, msgText, MsgType.INFORMATION_MESSAGE, options);
                        taskletResponse.noAction();
                    }
                } else {
                    taskletResponse.noAction();
                }
            }
        }
        catch (Exception e) {
            Trace.trace("XEDT   F", e);
        }
    }

    public void logException(Throwable throwable) {
    }

    private boolean isModified() {
        boolean temp = false;
        if (this.paging) {
            for (int i = 0; i < this.pages.size(); ++i) {
                if (!((Page)this.pages.get(i)).getModified()) continue;
                temp = true;
                break;
            }
        }
        if (!this.textEdit.equals(this.textEditRestore)) {
            temp = true;
        }
        return temp;
    }

    private File emptyDirectory() {
        File parent = new File(TEMP_DIRECTORY + this.subdirectory);
        if (parent.exists()) {
            File[] files = parent.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        return parent;
    }

    private boolean searchDown(String key) throws IOException {
        boolean found = false;
        String temp = new String();
        for (int i = this.currentPage + 1; i < this.pages.size(); ++i) {
            temp = ((Page)this.pages.get(i)).read();
            if (temp.indexOf(key) == -1) continue;
            found = true;
            this.currentPage = i;
            this.textEdit = temp;
            this.textEditRestore = new String(this.textEdit);
            break;
        }
        return found;
    }

    private boolean searchUp(String key) throws IOException {
        boolean found = false;
        String temp = new String();
        for (int i = this.currentPage - 1; i >= 0; --i) {
            temp = ((Page)this.pages.get(i)).read();
            if (temp.indexOf(key) == -1) continue;
            found = true;
            this.currentPage = i;
            this.textEdit = temp;
            this.textEditRestore = new String(this.textEdit);
            break;
        }
        return found;
    }

    private String loadFile() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.file));
        String temp = new String();
        if (this.paging) {
            int pageNumber = 0;
            while (this.readPage(pageNumber)) {
                ++pageNumber;
            }
            temp = ((Page)this.pages.get(0)).read();
        } else {
            int length = (int)this.file.length();
            char[] buffer = new char[length];
            this.reader.read(buffer, 0, length);
            temp = new String(buffer);
        }
        this.reader.close();
        return temp;
    }

    private boolean readPage(int pageNumber) throws IOException {
        boolean success = true;
        String page = new String();
        for (int i = 0; i < 20; ++i) {
            int character;
            StringBuffer temp = new StringBuffer();
            while ((character = this.reader.read()) != -1) {
                temp.append((char)character);
                if ((char)character != '\n') continue;
            }
            page = page.concat(new String(temp.toString()));
            if (character != -1) continue;
            success = false;
            break;
        }
        this.addPage(pageNumber, page);
        return success;
    }

    private void addPage(int pageNumber, String toWrite) throws IOException {
        Page temp = new Page(new File(TEMP_DIRECTORY + this.subdirectory + "/" + "page" + pageNumber));
        temp.write(toWrite);
        this.pages.add(temp);
    }

    private void writeFile() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.file));
        if (this.paging) {
            for (int i = 0; i < this.pages.size(); ++i) {
                String page = ((Page)this.pages.get(i)).read();
                this.writePage(page);
            }
        } else {
            this.writePage(this.textEdit);
        }
        this.writer.close();
    }

    private void writePage(String toWrite) throws IOException {
        this.writer.write(toWrite, 0, toWrite.length());
    }

    private class Page {
        private File _file;
        private boolean _modified;

        public Page(File file) throws IOException {
            this._file = file;
            this._modified = false;
            this._file.createNewFile();
        }

        public File getFile() {
            return this._file;
        }

        public void setModified(boolean b) {
            this._modified = b;
        }

        public boolean getModified() {
            return this._modified;
        }

        public String read() throws IOException {
            int length = (int)this._file.length();
            char[] buffer = new char[length];
            BufferedReader reader = new BufferedReader(new FileReader(this._file));
            reader.read(buffer, 0, length);
            reader.close();
            return new String(buffer);
        }

        public void write(String toWrite) throws IOException {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this._file));
            writer.write(toWrite, 0, toWrite.length());
            writer.close();
        }
    }
}

